/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.common.block.AbstractCrateBlock;
import dev.toma.gunsrpg.common.tileentity.InventoryTileEntity;
import dev.toma.gunsrpg.common.tileentity.MilitaryCrateTileEntity;
import dev.toma.gunsrpg.world.LootStashes;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class MilitaryCrateBlock
extends AbstractCrateBlock {
    private static final ITextComponent TITLE = new TranslationTextComponent("container.crate");
    private final BiomeVariant variant;

    public MilitaryCrateBlock(String name, BiomeVariant variant) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).harvestTool(ToolType.AXE).func_200944_c());
        this.variant = variant;
    }

    public BiomeVariant getVariant() {
        return this.variant;
    }

    @Override
    public ITextComponent getContainerTitle() {
        return TITLE;
    }

    @Override
    public boolean shouldDestroyEmptyBlock() {
        return true;
    }

    @Override
    public <T extends InventoryTileEntity> T getNewBlockEntity() {
        return (T)new MilitaryCrateTileEntity();
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        super.func_196243_a(state, world, pos, oldState, p_196243_5_);
        LootStashes.initiateImmediateRefresh();
    }

    public static enum BiomeVariant {
        ARTIC(-2.1474836E9f),
        WOODLAND(0.1f),
        DESERT(1.15f);

        public static final BiomeVariant[] BY_TEMPERATURE;
        private final float minTemperature;

        private BiomeVariant(float minTemperature) {
            this.minTemperature = minTemperature;
        }

        public float getMinTemperature() {
            return this.minTemperature;
        }

        static {
            BY_TEMPERATURE = (BiomeVariant[])Arrays.stream(BiomeVariant.values()).sorted(Comparator.comparingDouble(BiomeVariant::getMinTemperature)).toArray(BiomeVariant[]::new);
        }
    }
}

